uniform sampler2D waves;
uniform sampler2D img1;
uniform sampler2D img2;
uniform sampler2D imgboth;
uniform float loopStart0;
uniform float loopEnd0;
uniform float loopStart1;
uniform float loopEnd1;

void main()
{
	vec2 uv = gl_TexCoord[0].st;

	vec4 color = vec4(0.0,0.0,0.0,0.0);
	float h0 = texture2D(waves, vec2(uv.x, 0.25)).a;
	float h1 = texture2D(waves, vec2(uv.x, 0.75)).a;
	float y = 1.0 - uv.y;

	if (h0 > h1)
	{
		if (y <= h1)
			color = texture2D(imgboth, uv.xy);	
		else if (y <= h0)
			color = texture2D(img1, uv.xy);	
	}
	else 
	{
		if (y <= h0)
			color = texture2D(imgboth, uv.xy);	
		else if (y <= h1)
			color = texture2D(img2, uv.xy);	
	}

	float ca1 = step(loopStart0, uv.x)*step(uv.x, loopEnd0);
	float ca2 = step(loopStart1, uv.x)*step(uv.x, loopEnd1);
	if (ca1>0.5)
	{
		vec4 c=texture2D(img1, uv.xy)*(1.0-uv.y);
		color = max(color, c);
	}
	if (ca2>0.5)
	{
		vec4 c=texture2D(img2, uv.xy)*(1.0-uv.y);
		color = max(color, c);
	}

	gl_FragColor = color;
}
